<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBExperience 3.8                                                 # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2006-2009 Marius Czyz. All Rights Reserved.           # ||
|| #################################################################### ||
\*======================================================================*/


// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cpuser', 'forum', 'user', 'cpglobal');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_stats.php');
require_once(DIR . '/includes/functions_xperience.php');
require_once(DIR . '/includes/class_xperience.php');
// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}
 
// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['xperience_name']);


$vbulletin->input->clean_array_gpc('r', array(
	'do' => TYPE_STR,
	'id' => TYPE_INT
));


	

$current_timestamp=mktime(date("H"), date("i"), 0, date("m"), date("d"), date("Y"));

if ($vbulletin->GPC['do'] == 'mancpoints') 
{
	print_form_header('');
	print_table_header($vbphrase['xperience_admin_mancpoints'], 1);

	$pointsq =$vbulletin->db->query_read("SELECT
		user.username, c.*
		FROM " . TABLE_PREFIX . "xperience_custompoints as c
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (c.userid = user.userid)
		ORDER BY dateline
		");
		
		

	
		
		if ($vbulletin->db->num_rows($pointsq) > 0)
		{
			while ($points = $vbulletin->db->fetch_array($pointsq)) 
			{
				print_description_row('<a href="xperience_admin.php?do=editpoints&id='.$points['pointid'].'">'.vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $points['dateline']).', '.$points['username'].'</a><dfn> : '.$points['points_misc_custom'].', '.$points['comment'].'</dfn>');
			}
		} else {
				print_description_row($vbphrase['xperience_admin_no_custom_points']);
		}
		print_table_footer(1);

	print_form_header('');
	print_table_header(' ', 1);
	print_description_row('<a href="xperience_admin.php?do=addpoints">'.$vbphrase[xperience_admin_add_custom_points].'</a>');		
	print_table_footer(1);
}
if ($vbulletin->GPC['do'] == 'addpoints') 
{

	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_custompoints (adminid, dateline) VALUES (".$vbulletin->userinfo['userid'].", ".$current_timestamp.")");
	print_cp_message('Redirecting...', 'xperience_admin.php?do=editpoints&id='.$vbulletin->db->insert_id(), 0);

}
 
if ($vbulletin->GPC['do'] == 'editpoints') 
{
	print_form_header('xperience_admin', 'savepoints');
	print_table_header($vbphrase['xperience_admin_edit_custom_points'], 2, 0);
	
	$pointsq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_custompoints WHERE pointid=".$vbulletin->GPC['id']);
		
		if ($vbulletin->db->num_rows($pointsq) > 0)
		{
			$points = $vbulletin->db->fetch_array($pointsq);
			
			
			print_input_row($vbphrase['userid'], 'userid', $points['userid']);	
			print_input_row($vbphrase['xperience_admin_custom_points_neg'], 'points_misc_custom', $points['points_misc_custom']);	
			print_input_row($vbphrase['comment'], 'comment', $points['comment']);	
			print_checkbox_row($vbphrase['delete'], 'delpoints', false, 1);
			echo "<input type=\"hidden\" name=\"pointid\" value=\"" . $points['pointid'] . "\" />\n";
			print_submit_row($vbphrase['save']);
	}

}
 
 
 if ($vbulletin->GPC['do'] == 'savepoints') 
 {

	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_INT,
		'points_misc_custom' => TYPE_INT,
		'comment' => TYPE_STR,
		'delpoints' => TYPE_INT,
		'pointid' => TYPE_INT
	));

	if ($vbulletin->GPC['delpoints'] ==1) 
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "xperience_custompoints WHERE pointid=".$vbulletin->GPC['pointid']);
	}
	else
	{
		
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_custompoints SET
		userid=".$vbulletin->GPC['userid'].",
		points_misc_custom=".$vbulletin->GPC['points_misc_custom'].",
		comment='".addslashes($vbulletin->GPC['comment'])."'
		WHERE pointid=".$vbulletin->GPC['pointid']);
	}
	
	$calcuser = fetch_userinfo($vbulletin->GPC['userid']);	
	require_once(DIR . '/includes/class_xperience.php');
	$xPerience =& new xPerience;
	$xPerience->CalculateXP($calcuser, 0);
	$xPerience->CalculateAwards();
		
	print_done("xperience_admin.php?do=mancpoints");
}
 
 

if ($vbulletin->GPC['do'] == 'delstats') 
{
	print_form_header('');
	print_table_header($vbphrase['xperience_admin_delete_stats'], 3);
	print_description_row('<a href="xperience_admin.php?do=dodelstats"">'.$vbphrase[xperience_admin_delete_confirm].'</a>');
	print_table_footer(1);
}

if ($vbulletin->GPC['do'] == 'dodelstats') 
{
	
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "xperience_stats");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user 
		SET
		xperience_done=1, 
		xperience=0,
		xperience_level=0,
		xperience_next_level=0,
		xperience_next_level_points=0,
		xperience_ppd=0");
		
	print_done();
}

if ($vbulletin->GPC['do'] == 'genawards') 
{
	
	require_once(DIR . '/includes/class_xperience.php');
	$xPerience =& new xPerience;
	$xPerience->CalculateAwards();
	print_done("xperience_admin.php?do=manawards");
}

if ($vbulletin->GPC['do'] == 'manawards') 
{
	print_form_header('');
	print_table_header($vbphrase['xperience_admin_manawards'], 1);

	$awardsq =$vbulletin->db->query_read("SELECT
		*
		FROM " . TABLE_PREFIX . "xperience_awards
		ORDER BY awardstatus
		");
		
	if ($vbulletin->db->num_rows($awardsq) > 0)
	{
		while ($awards = $vbulletin->db->fetch_array($awardsq)) 
		{
			print_description_row($awards['awardstatus'].' <a href="xperience_admin.php?do=editaward&id='.$awards['awardid'].'">'.$awards['awardtitle'].'</a> (Pos. '.$awards['awardlimit'].')<dfn>'.$awards['awarddesc'].'</dfn>');
		}
	} else {
			print_description_row($vbphrase['xperience_admin_awards_none']);
	}
	print_table_footer(1);

	print_form_header('');
	print_table_header($vbphrase['xperience_awards'], 1);
	print_description_row('<a href="xperience_admin.php?do=addaward">'.$vbphrase[xperience_admin_awards_add].'</a>');
	print_description_row('<a href="xperience_admin.php?do=genawards">'.$vbphrase[xperience_admin_awards_gen].'</a>');
	print_table_footer(1);
}


if ($vbulletin->GPC['do'] == 'addaward') 
{
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_awards (awardlimit, awardtitle, awarddesc, awardstatus) VALUES (0, 'New Award', 'New great Award!', 0)");
	print_cp_message('Redirecting...', 'xperience_admin.php?do=editaward&id='.$vbulletin->db->insert_id(), 0);

}


if ($vbulletin->GPC['do'] == 'editaward') 
{
	print_form_header('xperience_admin', 'saveaward');
	print_table_header($vbphrase['xperience_admin_awards_edit'], 2, 0);
	
	$awardsq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_awards WHERE awardid=".$vbulletin->GPC['id']);
		
		if ($vbulletin->db->num_rows($awardsq) > 0)
		{
			$awards = $vbulletin->db->fetch_array($awardsq);
			
			print_input_row($vbphrase['xperience_admin_awards_id'], 'awardname', $awards['awardname']);	
			print_input_row($vbphrase['xperience_admin_awards_url'], 'awardurl', $awards['awardurl']);	
			print_input_row($vbphrase['title'], 'awardtitle', $awards['awardtitle']);	
			print_input_row($vbphrase['description'], 'awarddesc', $awards['awarddesc']);
			print_input_row($vbphrase['xperience_admin_awards_manualassign'], 'manualassign', $awards['manualassign']);
			print_input_row($vbphrase['xperience_admin_awards_limit'], 'awardlimit', $awards['awardlimit']);
			print_input_row("$vbphrase[display_order]<dfn>$vbphrase[zero_equals_no_display]</dfn>", 'awardstatus', $awards['awardstatus']);
			
			$fields = array();
			$sel_fields = array();
			$optionsq =$vbulletin->db->query_read("SHOW COLUMNS
			FROM " . TABLE_PREFIX . "xperience_stats LIKE 'points_%'");
					
			if ($vbulletin->db->num_rows($optionsq) > 0)
			{
				while ($options = $vbulletin->db->fetch_array($optionsq)) 
				{
					$fields["$options[Field]"] = $vbphrase['xperience_'.$options[Field]]; 
					if (strlen($fields["$options[Field]"])<1)
					{
						$fields["$options[Field]"] = $options["Field"];
					}
				}
			}
			array_multisort($fields, SORT_ASC, SORT_STRING);
			$sel_fields=explode("+", $awards['awardfields']);
			print_select_row($vbphrase['xperience_admin_awards_sum'], "awardfields[]", $fields, $sel_fields, false, $size = 30, $multiple = true);
			
			//TODO
			//print_input_row('Exclude Usergroups<dfn>These usergroups cannot get this award. Seperate them by a colon, e.g. 16,65,71</dfn>', 'awardexclusions', $awards['awardexclusions']);	
			
			print_checkbox_row($vbphrase['delete'], 'delaward', false, 1);
			echo "<input type=\"hidden\" name=\"awardid\" value=\"" . $awards['awardid'] . "\" />\n";
			print_submit_row($vbphrase['save']);
	}

}


if ($vbulletin->GPC['do'] == 'saveaward') 
{

	$vbulletin->input->clean_array_gpc('r', array(
		'awardname' => TYPE_STR,
		'awardtitle' => TYPE_STR,
		'awardurl' => TYPE_STR,
		'awarddesc' => TYPE_STR,
		'awardstatus' => TYPE_INT,
		'awardlimit' => TYPE_INT,
		'awardexclusions' => TYPE_STR,
		'awardid' => TYPE_UINT,
		'manualassign' => TYPE_STR,
		'delaward' => TYPE_UINT,
		'awardfields' => TYPE_ARRAY
	));



	if ($vbulletin->GPC['delaward'] ==1) 
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "xperience_awards WHERE awardid=".$vbulletin->GPC['awardid']);
	} else {
		
		$awardfields_str = implode("+", $vbulletin->GPC['awardfields']);
		if (strlen($awardfields_str)<2) $awardfields_str="+points_user";
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_awards SET
		awardname='".addslashes($vbulletin->GPC['awardname'])."',
		awardtitle='".addslashes($vbulletin->GPC['awardtitle'])."',
		awardurl='".addslashes($vbulletin->GPC['awardurl'])."',
		awarddesc='".addslashes($vbulletin->GPC['awarddesc'])."',
		awardstatus=".$vbulletin->GPC['awardstatus'].",
		awardlimit=".$vbulletin->GPC['awardlimit'].",
		manualassign='".addslashes($vbulletin->GPC['manualassign'])."',
		awardexclusions='".addslashes($vbulletin->GPC['awardexclusions'])."',
		awardfields='".addslashes($awardfields_str)."'
		WHERE awardid=".$vbulletin->GPC['awardid']);
	}
	
	require_once(DIR . '/includes/class_xperience.php');
	$xPerience =& new xPerience;
	$xPerience->CalculateAwards();
	
	print_done("xperience_admin.php?do=manawards");
}



if ($vbulletin->GPC['do'] == 'stats') 
{

	$members = $vbulletin->db->query_first("
		SELECT
		COUNT(*) AS users
		FROM " . TABLE_PREFIX . "user as u 
	"); 
	$userscount = $members['users'];

	// we'll need a poll image
	$style = $db->query_first("
		SELECT stylevars FROM " . TABLE_PREFIX . "style
		WHERE styleid = " . $vbulletin->options['styleid'] . "
		LIMIT 1
	");
	$stylevars = unserialize($style['stylevars']);
	unset($style);


	print_form_header('');
	print_table_header($vbphrase['xperience_admin_level_stats'], 3);
	print_cells_row(array($vbphrase['xperience_admin_level_level'], $vbphrase['xperience_admin_level_percent'], $vbphrase['xperience_admin_level_count']), 1);
        
	$levels = $vbulletin->db->query_read("SELECT
		xperience_level, COUNT(*) as levelcount
		FROM " . TABLE_PREFIX . "user
		GROUP BY xperience_level");
	
	while ($level = $vbulletin->db->fetch_array($levels)) 
	{ 
		$i++;
		$bar = ($i % 6) + 1; 
		print_statistic_result($level['xperience_level'], $bar, $level['levelcount'], ceil(($level['levelcount']/$userscount) * 100)); 
	}

	print_table_footer(3);
}



// ####################### 
// ####################### Shop
// ####################### 

if ($vbulletin->GPC['do'] == 'manshop') 
{
	print_form_header('');
	print_table_header($vbphrase['xperience_admin_manshop'], 1);

	$catq =$vbulletin->db->query_read("SELECT
		*
		FROM " . TABLE_PREFIX . "xperience_shop_cat
		ORDER BY catstatus
		");
		
	if ($vbulletin->db->num_rows($catq) > 0)
	{
		while ($cats = $vbulletin->db->fetch_array($catq)) 
		{
			$count_items = GetItemCount($cats['catid']);

			print_description_row($cats['catstatus'].' <a href="xperience_admin.php?do=editcat&id='.$cats['catid'].'">'.$cats['catname'].'</a> - ('.$count_items.' items) <a href="xperience_admin.php?do=manitems&id='.$cats['catid'].'">Edit Items</a><dfn>'.$cats['catdesc'].'</dfn>');
		}
	} else {
			print_description_row($vbphrase['xperience_admin_cat_none']);
	}
	print_table_footer(1);

	print_form_header('');
	print_table_header($vbphrase['xperience_admin_manshop'], 1);
	print_description_row('<a href="xperience_admin.php?do=addcat">'.$vbphrase[xperience_admin_cat_add].'</a>');
	print_description_row('<a href="xperience_admin.php?do=talog">'.$vbphrase[xperience_admin_talog_name].'</a>');
	print_description_row('==================');

	print_table_footer(1);
}


if ($vbulletin->GPC['do'] == 'delta') 
{
	$vbulletin->input->clean_gpc('r', 'id', TYPE_UINT);
	$vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);
	$vbulletin->input->clean_gpc('r', 'itemid', TYPE_UINT);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_shop SET quantity=quantity+1 WHERE itemid=".$vbulletin->GPC['itemid']);
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "xperience_shop_ta WHERE taid=".$vbulletin->GPC['id']);
	$calcuser = fetch_userinfo($vbulletin->GPC['userid']);

 	$xPerience =& new xPerience;
 	$xPerience->CalculateXP($calcuser, 0);
 	
	print_cp_message('Redirecting...', 'xperience_admin.php?do=talog', 0);
}

if ($vbulletin->GPC['do'] == 'talog') 
{
	print_form_header('');

	$vbulletin->input->clean_array_gpc('r', array(
		'pagenumber' => TYPE_UINT,
		'orderby'    => TYPE_NOHTML,
	));

	$perpage=25;
	$counter = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "xperience_shop_ta AS t
	");
	$totalpages = ceil($counter['total'] / $perpage);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $perpage;

		print_table_header(construct_phrase($vbphrase['xperience_admin_talog'], vb_number_format($vbulletin->GPC['pagenumber']), vb_number_format($totalpages), vb_number_format($counter['total'])), 6);
	$talogq =$vbulletin->db->query_read("SELECT
		u.username,
		t.*,
		s.*
		FROM " . TABLE_PREFIX . "xperience_shop_ta as t
		INNER JOIN " . TABLE_PREFIX . "xperience_shop as s ON t.itemid=s.itemid
		INNER JOIN " . TABLE_PREFIX . "user as u ON t.buyer = u.userid	
		ORDER BY t.dateline DESC
		LIMIT ".$startat.", ".$perpage);
	
	if ($vbulletin->db->num_rows($talogq) > 0)
	{
		
		if ($vbulletin->GPC['pagenumber'] != 1)
		{
			$prv = $vbulletin->GPC['pagenumber'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='xperience_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=talog&orderby=" . $vbulletin->GPC['orderby'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='xperience_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=talog&orderby=" . $vbulletin->GPC['orderby'] . "&page=$prv'\">";
		}

		if ($vbulletin->GPC['pagenumber'] != $totalpages)
		{
			$nxt = $vbulletin->GPC['pagenumber'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='xperience_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=talog&orderby=" . $vbulletin->GPC['orderby'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='xperience_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=talog&orderby=" . $vbulletin->GPC['orderby'] . "&page=$totalpages'\">";
		}
		
		
		$cellh = array();
		$cellh[] = $vbphrase['date'];
		$cellh[] = $vbphrase['username'];
		$cellh[] = $vbphrase['title'];
		$cellh[] = $vbphrase['xperience_admin_items_costs']; 
		$cellh[] = $vbphrase['xperience_admin_items_costfield']; 
		$cellh[] = $vbphrase['delete']; 
		print_cells_row($cellh, true);


		while ($talog = $vbulletin->db->fetch_array($talogq))
		{
			$cell = array();
			$cell[] = vbdate($vbulletin->options['dateformat'] . ' ' .  $vbulletin->options['timeformat'], $talog['dateline']); 
			$cell[] = $talog['username'];
			$cell[] = $talog['itemname'];
			$cell[] = vb_number_format($talog['costs']); 
			$cell[] = $vbphrase['xperience_'.$talog[costfield]]; 
			$cell[] = '<a href="xperience_admin.php?do=delta&itemid='.$talog['itemid'].'&id='.$talog['taid'].'&userid='.$talog['buyer'].'">'.$vbphrase['delete'].'</a>'; 
			print_cells_row($cell);
		}
	} else {
		$cellh = array();
		$cellh[] = $vbphrase['no_matches_found'];
		print_cells_row($cellh);
	}
		print_table_footer(6, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
}


	
if ($vbulletin->GPC['do'] == 'addcat') 
{
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_shop_cat (catname, catdesc) VALUES ('New category', 'This is a new category')");
	print_cp_message('Redirecting...', 'xperience_admin.php?do=editcat&id='.$vbulletin->db->insert_id(), 0);

}


if ($vbulletin->GPC['do'] == 'editcat') 
{

	
	$awardsq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_shop_cat WHERE catid=".$vbulletin->GPC['id']);
		
		if ($vbulletin->db->num_rows($awardsq) > 0)
		{
			$awards = $vbulletin->db->fetch_array($awardsq);
			print_form_header('xperience_admin', 'savecat');
			print_table_header($vbphrase['xperience_admin_cat_edit']." (ID# ".$awards['catid'].")", 2, 0);
	
			print_input_row($vbphrase['title'], 'catname', $awards['catname']);	
			print_input_row($vbphrase['description'], 'catdesc', $awards['catdesc']);
			print_input_row($vbphrase['xperience_admin_cat_parent'], 'catparent', $awards['catparent']);
			print_input_row("$vbphrase[display_order]<dfn>$vbphrase[zero_equals_no_display]</dfn>", 'catstatus', $awards['catstatus']);
			
				
			print_checkbox_row($vbphrase['delete'], 'delcat', false, 1);
			echo "<input type=\"hidden\" name=\"catid\" value=\"" . $awards['catid'] . "\" />\n";
			print_submit_row($vbphrase['save']);
	}

}


if ($vbulletin->GPC['do'] == 'savecat') 
{

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'catname' => TYPE_STR,
		'catdesc' => TYPE_STR,
		'catparent' => TYPE_INT,
		'catstatus' => TYPE_INT,
		'delcat' => TYPE_UINT
	));



	if ($vbulletin->GPC['delcat'] == 1) 
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "xperience_shop_cat WHERE catid=".$vbulletin->GPC['catid']);
	} else {
		
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_shop_cat SET
		catname='".addslashes($vbulletin->GPC['catname'])."',
		catdesc='".addslashes($vbulletin->GPC['catdesc'])."',
		catparent=".addslashes($vbulletin->GPC['catparent']).",
		catstatus=".addslashes($vbulletin->GPC['catstatus'])."
		WHERE catid=".$vbulletin->GPC['catid']);
	}
	
	print_done("xperience_admin.php?do=manshop");
}







if ($vbulletin->GPC['do'] == 'manitems') 
{
	print_form_header('');
	print_table_header($vbphrase['xperience_admin_manitems'], 1);

	$itemsq =$vbulletin->db->query_read("SELECT
		*
		FROM " . TABLE_PREFIX . "xperience_shop
		WHERE catid=".$vbulletin->GPC['id']."
		ORDER BY itemstatus
		");
		
	if ($vbulletin->db->num_rows($itemsq) > 0)
	{
		while ($items = $vbulletin->db->fetch_array($itemsq)) 
		{
			print_description_row($items['itemstatus'].' <a href="xperience_admin.php?do=edititem&id='.$items['itemid'].'">'.$items['itemname'].'</a> (Pos. '.$items['itemstatus'].')');
		}
	} else {
			print_description_row($vbphrase['xperience_admin_items_none']);
	}
	print_table_footer(1);

	print_form_header('');
	print_table_header($vbphrase['xperience_items'], 1);
	print_description_row('<a href="xperience_admin.php?do=additem&id='.$vbulletin->GPC['id'].'">'.$vbphrase[xperience_admin_items_add].'</a>');
	print_description_row('<a href="xperience_admin.php?do=genshopitems&id='.$vbulletin->GPC['id'].'">'.$vbphrase[xperience_admin_items_gen].'</a>');
	print_table_footer(1);
}

if ($vbulletin->GPC['do'] == 'genshopitems') 
{
	require_once('./includes/functions_xperience.php');
	$users = $vbulletin->db->query_read("SELECT 
		u.userid 
		FROM " . TABLE_PREFIX . "user as u"
		);
		
	while ($user = $vbulletin->db->fetch_array($users))
	{
		WriteShopItems($user);
	}

	print_done("xperience_admin.php?do=manitems&id=".$vbulletin->GPC['id']);

}

if ($vbulletin->GPC['do'] == 'additem') 
{
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_shop (catid, itemname, itemdesc, costfield) VALUES (".$vbulletin->GPC['id'].", 'New item', 'New great item!', 'points_misc_custom')");
	print_cp_message('Redirecting...', 'xperience_admin.php?do=edititem&id='.$vbulletin->db->insert_id(), 0);

}

if ($vbulletin->GPC['do'] == 'edititem') 
{
	print_form_header('xperience_admin', 'saveitem');
	print_table_header($vbphrase['xperience_admin_items_edit'], 2, 0);
	
	$itemsq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_shop WHERE itemid=".$vbulletin->GPC['id']);
		
		if ($vbulletin->db->num_rows($itemsq) > 0)
		{
			$items = $vbulletin->db->fetch_array($itemsq);
			
			print_input_row($vbphrase['title'], 'itemname', $items['itemname']);	
			print_textarea_row($vbphrase['description'], 'itemdesc', $items['itemdesc']);
			print_input_row($vbphrase['xperience_admin_items_picture'], 'itempicture', $items['itempicture']);
			print_input_row($vbphrase['xperience_admin_items_thumb'], 'itemthumb', $items['itemthumb']);
			print_input_row($vbphrase['xperience_admin_items_icon'], 'itemicon', $items['itemicon']);
			print_input_row($vbphrase['xperience_admin_items_catid'], 'catid', $items['catid']);
			print_input_row($vbphrase['xperience_admin_items_quantity'], 'quantity', $items['quantity']);
			print_input_row($vbphrase['xperience_admin_items_costs'], 'costs', $items['costs']);
		
			$fields = array();
			$sel_fields = array();
			
			$filterfields = array('points_user_activity');
			$optionsq =$vbulletin->db->query_read("SHOW COLUMNS
				FROM " . TABLE_PREFIX . "xperience_stats LIKE 'points_%'");
			
			if ($vbulletin->db->num_rows($optionsq) > 0)
			{
				while ($options = $vbulletin->db->fetch_array($optionsq)) 
				{
					if (!in_array($options['Field'], $filterfields))
					{
						$fields["$options[Field]"] = $vbphrase['xperience_'.$options[Field]]; 
						if (strlen($fields["$options[Field]"])<1)
						{
							$fields["$options[Field]"] = $options["Field"];
						}
					}
				}
			}

			array_multisort($fields, SORT_ASC, SORT_STRING);
			$filteredfields = array_diff($fields, $filterfields);
			print_select_row($vbphrase['xperience_admin_items_costfield'], "costfield", $filteredfields, $items['costfield'], false, $size = 1, $multiple = false);
			
			print_input_row("$vbphrase[display_order]<dfn>$vbphrase[zero_equals_no_display]</dfn>", 'itemstatus', $items['itemstatus']);
			
						
			print_checkbox_row($vbphrase['delete'], 'delitem', false, 1);
			echo "<input type=\"hidden\" name=\"itemid\" value=\"" . $items['itemid'] . "\" />\n";
			print_submit_row($vbphrase['save']);
	}

}


if ($vbulletin->GPC['do'] == 'saveitem') 
{

	$vbulletin->input->clean_array_gpc('r', array(
		'itemid' => TYPE_INT,
		'itemname' => TYPE_STR,
		'itemdesc' => TYPE_STR,
		'itempicture' => TYPE_STR,
		'itemthumb' => TYPE_STR,		
		'itemicon' => TYPE_STR,	
		'itemstatus' => TYPE_INT,
		'catid' => TYPE_INT,
		'quantity' => TYPE_INT,
		'costs' => TYPE_UINT,
		'costfield' => TYPE_STR,
		'delitem' => TYPE_UINT
	));



	if ($vbulletin->GPC['delitem'] == 1) 
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "xperience_shop WHERE itemid=".$vbulletin->GPC['itemid']);
	} else {
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_shop SET
			itemname='".addslashes($vbulletin->GPC['itemname'])."',
			itemdesc='".addslashes($vbulletin->GPC['itemdesc'])."',
			itempicture='".addslashes($vbulletin->GPC['itempicture'])."',
			itemthumb='".addslashes($vbulletin->GPC['itemthumb'])."',
			itemicon='".addslashes($vbulletin->GPC['itemicon'])."',
			itemstatus=".$vbulletin->GPC['itemstatus'].",
			catid=".$vbulletin->GPC['catid'].",
			quantity=".$vbulletin->GPC['quantity'].",
			costs=".$vbulletin->GPC['costs'].",
			costfield='".addslashes($vbulletin->GPC['costfield'])."'
			WHERE itemid=".$vbulletin->GPC['itemid']);
	}
	
	print_done("xperience_admin.php?do=manitems&id=".$vbulletin->GPC['catid']);
}






function print_done($Link = 'xperience_admin.php') 
{
	print_form_header('');
	print_table_header("", 1);
	print_description_row(' ');
	print_description_row('<a href="'.$Link.'">   </a>');
	print_table_footer(1);
}

print_cp_footer();


?>
